/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.servlet;

import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.settings.user.BonsaiUserSettings;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager;
import com.ibm.hwmca.ui.bonsai.earth.TaskManager;
import com.ibm.hwmca.ui.bonsai.earth.TaskNode;
import com.ibm.hwmca.ui.bonsai.servlet.ActionBase;
import com.ibm.hwmca.ui.bonsai.servlet.util.UISession;
import com.ibm.hwmca.ui.bonsai.table.NameTableCellBean;
import com.ibm.hwmca.ui.bonsai.table.SystemNameTableCell;
import com.ibm.hwmca.ui.bonsai.table.TreeTableModel;
import com.ibm.hwmca.ui.bonsai.util.SettingsRetriever;
import com.ibm.psw.wcl.components.menu.DefaultMenuModel;
import com.ibm.psw.wcl.components.menu.IMenuItem;
import com.ibm.psw.wcl.components.menu.IMenuModel;
import com.ibm.psw.wcl.components.menu.MenuInfo;
import com.ibm.psw.wcl.components.menu.MenuItemInfo;
import com.ibm.psw.wcl.components.menu.WMenuButton;
import com.ibm.psw.wcl.components.table.DefaultExtendedTableModel;
import com.ibm.psw.wcl.components.table.IExtendedTableModel;
import com.ibm.psw.wcl.components.table.ITableColumnModel;
import com.ibm.psw.wcl.components.table.WTable;
import com.ibm.psw.wcl.components.table.WTableColumn;
import com.ibm.psw.wcl.components.toolbar.WToolbar;
import com.ibm.psw.wcl.components.toolbar.WToolbarLayout;
import com.ibm.psw.wcl.components.tree.DefaultExtendedTreeModel;
import com.ibm.psw.wcl.components.tree.ExtendedTreeSelectionEvent;
import com.ibm.psw.wcl.components.tree.IExtendedTreeModel;
import com.ibm.psw.wcl.components.tree.IExtendedTreeSelectionListener;
import com.ibm.psw.wcl.components.tree.WTree;
import com.ibm.psw.wcl.core.AContext;
import com.ibm.psw.wcl.core.CommandEvent;
import com.ibm.psw.wcl.core.ExtendedListSelectionEvent;
import com.ibm.psw.wcl.core.ICommandListener;
import com.ibm.psw.wcl.core.IExtendedListSelectionListener;
import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.TriggerContext;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.WContainer;
import com.ibm.psw.wcl.core.WPage;
import com.ibm.psw.wcl.core.cell.AWCell;
import com.ibm.psw.wcl.core.cell.DefaultCell;
import com.ibm.psw.wcl.core.cell.DefaultHyperlinkCell;
import com.ibm.psw.wcl.core.frame.AWFrame;
import com.ibm.psw.wcl.core.frame.WFrame;
import com.ibm.psw.wcl.core.layout.WFramesetLayout;
import com.ibm.psw.wcl.core.layout.WTitledLayout;
import com.ibm.psw.wcl.core.renderer.RendererException;
import com.ibm.psw.wcl.core.renderer.RendererInfo;
import com.ibm.psw.wcl.core.skin.AStyleInfo;
import com.ibm.psw.wcl.skins.base.BaseTableStyleInfo;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ResourcesWorkareaAction
extends ActionBase
implements Serializable {
    static final long serialVersionUID = 7056979289469113935L;
    public static final String RESOURCES_FRAME_NAME = "resources_workarea_frame";
    public static final String TASKS_FRAME_NAME = "tasks_frame";
    public static final String RESOURCES_TASKAREA_FRAME_TARGET = "frames['workarea_frame'].frames['tasks_frame']";
    public static final String TASKAREA_JSP = "tasksarea.jsp";
    public static final int DEFAULT_VIEWPORT_ROWS = 17;
    public static final int DEFAULT_VIEWPORT_ROWS_TASKS = 10;
    public static final int NAME_COLUMN = 0;
    private static final String TRACEMASKT = "XBRWACTT";
    private static final String TRACEMASKF = "XBRWACTF";
    private static final String TRACEMASKD = "XBRWACTD";
    static /* synthetic */ Class class$com$ibm$hwmca$ui$bonsai$table$StatusTableCellBean;
    static /* synthetic */ Class class$com$ibm$hwmca$ui$bonsai$table$SystemStatusTableCellRenderer;
    static /* synthetic */ Class class$com$ibm$hwmca$ui$bonsai$table$NameTableCellBean;
    static /* synthetic */ Class class$com$ibm$hwmca$ui$bonsai$table$SystemTableCellRenderer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$ibm$hwmca$ui$bonsai$table$DefaultTableCellRenderer;
    static /* synthetic */ Class class$com$ibm$hwmca$ui$bonsai$earth$TaskNode;
    static /* synthetic */ Class class$com$ibm$hwmca$ui$bonsai$tree$TasksTreeCellRenderer;

    public WPage perform(HttpServlet servlet, HttpServletRequest request, HttpServletResponse response, RenderingContext rc) throws IOException, ServletException {
        Trace.trace(TRACEMASKT, "-> ResourcesWorkareaAction.perform()");
        BonsaiUserSettings settings = null;
        try {
            settings = SettingsRetriever.getUserSettings();
        }
        catch (TaskletException e) {
            throw new ServletException("Error creating settings retriever.", (Throwable)e);
        }
        HttpSession session = request.getSession(false);
        HMCSession hmcSession = HMCSession.getHMCSession(session);
        UISession uis = UISession.getUISession(hmcSession);
        String id = uis.getTreeSelection();
        if (id == null) {
            return null;
        }
        EResourcesWorkarea eResourcesWorkarea = (EResourcesWorkarea)session.getAttribute("EResourcesWorkarea");
        if (eResourcesWorkarea == null) {
            this.setDefaultStyles(rc);
            eResourcesWorkarea = new EResourcesWorkarea();
            session.setAttribute("EResourcesWorkarea", (Object)eResourcesWorkarea);
        }
        WPage docContainer = eResourcesWorkarea.getResourcesDocument(rc, session, uis, settings.isShowTasksView());
        String sReqParam = request.getParameter("refresh_type");
        if (sReqParam != null) {
            int iReqParam = Integer.parseInt(sReqParam);
            TreeTableModel ttModel = BonsaiTreeManager.getBonsaiTreeManager().getTableModel(id, uis, rc.getLocale());
            if (iReqParam == 1) {
                ((DefaultExtendedTableModel)eResourcesWorkarea.getTable_().getModel()).setDataVector(ttModel.getDataVectorMatrix(), 0);
            } else if (iReqParam == 2) {
                ((DefaultExtendedTableModel)eResourcesWorkarea.getTable_().getModel()).setDataVector(ttModel.getDataVectorMatrix(), ttModel.getColumnVectorHeaders());
                String title = BonsaiTreeManager.getBonsaiTreeManager().getTreeNode(id).getUIInfo().getName(rc.getLocale());
                eResourcesWorkarea.getTableTitle_().setTitle(title);
                TaskManager.getTaskManager().clearTasks(uis);
                eResourcesWorkarea.clearTableMenuButton();
                if (eResourcesWorkarea.isBShowTasksLayout_()) {
                    eResourcesWorkarea.updateTasksPage(rc, session, uis);
                }
            }
            eResourcesWorkarea.refreshTasksFrame(hmcSession);
            this.applyColumnStyles(eResourcesWorkarea, rc);
        }
        Trace.trace(TRACEMASKT, "<- ResourcesWorkareaAction.perform()");
        return docContainer;
    }

    private void applyColumnStyles(EResourcesWorkarea workarea, RenderingContext rc) {
        Object asi = null;
        WTable table = workarea.getTable_();
        table.setStyleInfo((AStyleInfo)new BaseTableStyleInfo());
        ITableColumnModel cm = table.getColumnModel();
        int cols = cm.getColumnCount();
        for (int i = 0; i < cols; ++i) {
            WTableColumn tableCol = cm.getColumn(i);
            if (tableCol == null) continue;
            tableCol.setHeaderValue((Object)("<font size=-1>" + tableCol.getHeaderValue() + "</font>"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class EResourcesWorkarea
    implements IExtendedTreeSelectionListener,
    IExtendedListSelectionListener,
    ICommandListener,
    Serializable {
        private WPage tablePage_ = null;
        private WPage tasksPage_ = null;
        private WTable table_ = null;
        private WTitledLayout tableTitle_ = null;
        private WFrame tableFrame_ = null;
        private WFrame tasksFrame_ = null;
        private WPage docContainer_ = null;
        private WToolbar actionToolbar = null;
        private WTree tree = null;
        private WMenuButton menuButton = null;
        private List lIds = null;
        private boolean bHorizontalLayout = true;
        private boolean bShowTasksLayout_ = false;
        private WFramesetLayout frameset_ = null;

        public WPage getResourcesDocument(RenderingContext rc, HttpSession session, UISession uis, boolean showTasksSetting) throws IOException, ServletException {
            Trace.trace(ResourcesWorkareaAction.TRACEMASKT, "-> ResourcesWorkareaAction.getResourcesDocument()");
            if (this.docContainer_ == null) {
                this.bShowTasksLayout_ = showTasksSetting;
                this.createResourcesDocument(rc, session, uis);
            } else if (showTasksSetting != this.bShowTasksLayout_) {
                this.setupTasksLayout(showTasksSetting, rc, session, uis);
                this.table_.setRowsPerViewport(showTasksSetting ? 10 : 17);
                this.table_.setDirty(true);
                this.tableFrame_.setDirty(true);
                this.bShowTasksLayout_ = showTasksSetting;
            }
            Trace.trace(ResourcesWorkareaAction.TRACEMASKT, "<- ResourcesWorkareaAction.getResourcesDocument()");
            return this.docContainer_;
        }

        private void createResourcesDocument(RenderingContext rc, HttpSession session, UISession uis) throws IOException, ServletException {
            Trace.trace(ResourcesWorkareaAction.TRACEMASKT, "-> ResourcesWorkareaAction.createResourcesDocument()");
            try {
                this.docContainer_ = new WPage("ResourcesWorkareaAction");
                this.docContainer_.setID("ResourcesWorkareaActionDocumentContainer");
                this.table_ = new WTable((IExtendedTableModel)new DefaultExtendedTableModel(), null, 699);
                this.table_.setSelectionMode(2);
                this.table_.getModel().addListSelectionListener((IExtendedListSelectionListener)this);
                this.table_.setClassRenderer(class$com$ibm$hwmca$ui$bonsai$table$StatusTableCellBean == null ? (class$com$ibm$hwmca$ui$bonsai$table$StatusTableCellBean = ResourcesWorkareaAction.class$("com.ibm.hwmca.ui.bonsai.table.StatusTableCellBean")) : class$com$ibm$hwmca$ui$bonsai$table$StatusTableCellBean, class$com$ibm$hwmca$ui$bonsai$table$SystemStatusTableCellRenderer == null ? (class$com$ibm$hwmca$ui$bonsai$table$SystemStatusTableCellRenderer = ResourcesWorkareaAction.class$("com.ibm.hwmca.ui.bonsai.table.SystemStatusTableCellRenderer")) : class$com$ibm$hwmca$ui$bonsai$table$SystemStatusTableCellRenderer, (AWCell)new DefaultCell(), RendererInfo.HTML_ALL);
                this.table_.setClassRenderer(class$com$ibm$hwmca$ui$bonsai$table$NameTableCellBean == null ? (class$com$ibm$hwmca$ui$bonsai$table$NameTableCellBean = ResourcesWorkareaAction.class$("com.ibm.hwmca.ui.bonsai.table.NameTableCellBean")) : class$com$ibm$hwmca$ui$bonsai$table$NameTableCellBean, class$com$ibm$hwmca$ui$bonsai$table$SystemTableCellRenderer == null ? (class$com$ibm$hwmca$ui$bonsai$table$SystemTableCellRenderer = ResourcesWorkareaAction.class$("com.ibm.hwmca.ui.bonsai.table.SystemTableCellRenderer")) : class$com$ibm$hwmca$ui$bonsai$table$SystemTableCellRenderer, (AWCell)new SystemNameTableCell(), RendererInfo.HTML_ALL);
                this.table_.setClassRenderer(class$java$lang$String == null ? (class$java$lang$String = ResourcesWorkareaAction.class$("java.lang.String")) : class$java$lang$String, class$com$ibm$hwmca$ui$bonsai$table$DefaultTableCellRenderer == null ? (class$com$ibm$hwmca$ui$bonsai$table$DefaultTableCellRenderer = ResourcesWorkareaAction.class$("com.ibm.hwmca.ui.bonsai.table.DefaultTableCellRenderer")) : class$com$ibm$hwmca$ui$bonsai$table$DefaultTableCellRenderer, (AWCell)new DefaultCell(), RendererInfo.HTML_ALL);
                this.table_.setRowsPerViewport(this.bShowTasksLayout_ ? 10 : 17);
                this.table_.getToolbarLayout().setBuildDirection("down");
                this.actionToolbar = new WToolbar();
                this.actionToolbar.setID("BonsaiTasksToolbar");
                this.actionToolbar.setGap(1);
                this.menuButton = new WMenuButton("Tasks");
                this.menuButton.addCommandListener((ICommandListener)this);
                this.menuButton.setID("BonsaiTableTasksMenuButton");
                this.menuButton.setEnabled(false);
                this.actionToolbar.add((WComponent)this.menuButton);
                this.table_.getToolbarLayout().addToolbar(this.actionToolbar);
                this.tableFrame_ = new WFrame();
                this.tableFrame_.setName(ResourcesWorkareaAction.RESOURCES_FRAME_NAME);
                this.tableFrame_.setID("resourcesWorkareaPageID");
                this.tablePage_ = new WPage();
                this.tablePage_.setID("ContentAreaTablePage");
                this.tableFrame_.add((WComponent)this.tablePage_);
                rc.getFrameReloadManager().registerFrameReloadable((AWFrame)this.tasksFrame_);
                this.tableTitle_ = new WTitledLayout("");
                AStyleInfo style = this.tableTitle_.getStyleInfo(rc.getSkin());
                style.setStyleValue("font-size", (Object)"10pt");
                this.tablePage_.add((WComponent)this.tableTitle_);
                this.tableTitle_.add((WComponent)this.table_);
                this.frameset_ = new WFramesetLayout();
                this.setupTasksLayout(this.bShowTasksLayout_, rc, session, uis);
                this.docContainer_.add((WComponent)this.frameset_);
            }
            catch (Exception ex) {
                this.table_ = null;
                throw new ServletException("Error creating WPage and contained objects in ResourcesWorkareaAction.", (Throwable)ex);
            }
            Trace.trace(ResourcesWorkareaAction.TRACEMASKT, "<- ResourcesWorkareaAction.createResourcesDocument()");
        }

        public void valueChanged(ExtendedListSelectionEvent e) {
            DefaultExtendedTableModel tableModel = (DefaultExtendedTableModel)e.getSource();
            AContext context = e.getContext();
            if (tableModel == null || context == null) {
                return;
            }
            HMCSession hmcSession = HMCSession.getHMCSession(context.getSession());
            UISession uiSession = UISession.getUISession(hmcSession);
            int[] selectedRows = tableModel.getSelectedModelRows();
            ArrayList<String> newSelectionsIds = new ArrayList<String>(selectedRows.length);
            for (int i = 0; i < selectedRows.length; ++i) {
                newSelectionsIds.add(((NameTableCellBean)tableModel.getValueAt(selectedRows[i], 0)).getId());
            }
            if (newSelectionsIds.isEmpty()) {
                uiSession.setActiveSelectionTree(true);
                TaskManager.getTaskManager().clearTasks(uiSession);
                this.clearTableMenuButton();
                try {
                    this.updateTasksPage(null, context.getSession(), uiSession);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (ServletException e1) {
                    e1.printStackTrace();
                }
                this.refreshTasksFrame(hmcSession);
                return;
            }
            ArrayList formerSelections = null;
            if (uiSession.isActiveSelectionTree()) {
                uiSession.setActiveSelectionTree(false);
                formerSelections = new ArrayList(0);
            } else {
                formerSelections = uiSession.getTableSelection();
            }
            uiSession.setTableSelection(newSelectionsIds);
            BonsaiTreeManager treeManager = BonsaiTreeManager.getBonsaiTreeManager();
            if (TaskManager.getTaskManager().updateTasks(treeManager.getTreeNodes(formerSelections), treeManager.getTreeNodes(newSelectionsIds), uiSession)) {
                this.updateTableMenuButton(uiSession);
                try {
                    this.updateTasksPage(null, context.getSession(), uiSession);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (ServletException e1) {
                    e1.printStackTrace();
                }
                this.refreshTasksFrame(hmcSession);
            }
        }

        public WTable getTable_() {
            return this.table_;
        }

        public WPage getTablePage_() {
            return this.tablePage_;
        }

        public WTitledLayout getTableTitle_() {
            return this.tableTitle_;
        }

        private void setupTasksLayout(boolean showTaskArea, RenderingContext rc, HttpSession session, UISession uis) throws IOException, ServletException {
            String[] sizes = this.frameset_.getRows();
            if (sizes.length == 0) {
                this.frameset_.addRow("0%");
                this.frameset_.addRow("0%");
                sizes = this.frameset_.getRows();
                this.frameset_.add((WComponent)this.tableFrame_);
            }
            if (!showTaskArea) {
                sizes[0] = "100%";
                sizes[1] = "0%";
                if (this.frameset_.contains((WComponent)this.tasksFrame_)) {
                    this.frameset_.remove((WComponent)this.tasksFrame_);
                }
                rc.getFrameReloadManager().deregisterFrameReloadable((AWFrame)this.tasksFrame_);
            } else {
                sizes[0] = "65%";
                sizes[1] = "35%";
                this.frameset_.add((WComponent)this.getTasksFrame(rc));
                rc.getFrameReloadManager().registerFrameReloadable((AWFrame)this.tasksFrame_);
            }
            this.frameset_.setRows(sizes);
        }

        private WFrame getTasksFrame(RenderingContext rc) {
            if (this.tasksPage_ == null) {
                this.tasksPage_ = new WPage();
                this.tasksFrame_ = new WFrame(this.tasksPage_);
                this.tasksFrame_.setName(ResourcesWorkareaAction.TASKS_FRAME_NAME);
                rc.getFrameReloadManager().registerFrameReloadable((AWFrame)this.tasksFrame_);
            }
            return this.tasksFrame_;
        }

        private void updateTasksPage(RenderingContext rc, HttpSession session, UISession uis) throws IOException, ServletException {
            if (this.bShowTasksLayout_ && this.tasksPage_ != null) {
                this.tasksPage_.removeAll();
                this.tasksPage_.add((WComponent)this.buildTree(session, rc, uis));
            }
        }

        private void refreshTasksFrame(HMCSession hmcSession) {
            if (this.bShowTasksLayout_) {
                this.tasksFrame_.setDirty(true);
            }
        }

        public void clearTableMenuButton() {
            this.getMenuButton().setModel((IMenuModel)new DefaultMenuModel());
        }

        private void updateTableMenuButton(UISession uis) {
            List lTaskNodes = uis.getResourceTaskTrees();
            MenuInfo root = new MenuInfo();
            this.buildMenuItems(root, lTaskNodes);
            WMenuButton menuButton = this.getMenuButton();
            menuButton.setModel((IMenuModel)new DefaultMenuModel((IMenuItem)root));
            menuButton.setEnabled(true);
        }

        private void buildMenuItems(MenuInfo root, List lTaskNodes) {
            TaskNode tNode = null;
            Iterator iter = lTaskNodes.iterator();
            while (iter.hasNext()) {
                tNode = (TaskNode)iter.next();
                List lTaskNodeChildren = tNode.getChildren();
                if (lTaskNodeChildren != null && lTaskNodeChildren.size() > 0) {
                    MenuInfo group = new MenuInfo(tNode.getName());
                    root.addChild((IMenuItem)group);
                    this.buildMenuItems(group, lTaskNodeChildren);
                    continue;
                }
                String str = tNode.getName();
                if (str != null) {
                    str = str.replace('\n', ' ');
                }
                MenuItemInfo mi = new MenuItemInfo();
                mi.setText(str);
                mi.setOnClick("document.location.href = '" + tNode.getUrlString() + "'");
                root.addChild((IMenuItem)mi);
            }
        }

        private WTree buildTree(HttpSession session, RenderingContext rc, UISession uis) throws ServletException {
            this.lIds = this.getListOfIds(uis);
            List selectedNodes = null;
            List lTaskNodes = null;
            StringBuffer sbTasksTitle = new StringBuffer();
            if (!this.lIds.isEmpty()) {
                selectedNodes = BonsaiTreeManager.getBonsaiTreeManager().getTreeNodes(this.lIds);
                lTaskNodes = TaskManager.getTaskManager().getTasks(selectedNodes, uis);
            }
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Tasks");
            this.buildMenuItems(rootNode, lTaskNodes);
            DefaultExtendedTreeModel treeModel = new DefaultExtendedTreeModel((TreeNode)rootNode);
            this.tree = new WTree((IExtendedTreeModel)treeModel, 510);
            this.tree.addTreeSelectionListener((IExtendedTreeSelectionListener)this);
            this.tree.setID("BonsaiNavAreaTreeModel");
            this.tree.setRootVisible(false);
            this.tree.setSelectionOnCollapse(true);
            WToolbarLayout tbl = this.tree.getToolbarLayout();
            WToolbar tb = tbl.getToolbar(0, 1);
            try {
                this.tree.setCellRenderer(class$com$ibm$hwmca$ui$bonsai$earth$TaskNode == null ? (class$com$ibm$hwmca$ui$bonsai$earth$TaskNode = ResourcesWorkareaAction.class$("com.ibm.hwmca.ui.bonsai.earth.TaskNode")) : class$com$ibm$hwmca$ui$bonsai$earth$TaskNode, class$com$ibm$hwmca$ui$bonsai$tree$TasksTreeCellRenderer == null ? (class$com$ibm$hwmca$ui$bonsai$tree$TasksTreeCellRenderer = ResourcesWorkareaAction.class$("com.ibm.hwmca.ui.bonsai.tree.TasksTreeCellRenderer")) : class$com$ibm$hwmca$ui$bonsai$tree$TasksTreeCellRenderer, (AWCell)new DefaultHyperlinkCell(), RendererInfo.HTML_ALL);
            }
            catch (RendererException e) {
                throw new ServletException("Error setting the cell renderer for tree.", (Throwable)e);
            }
            this.tree.expandRow(0);
            return this.tree;
        }

        private List getListOfIds(UISession uis) {
            ArrayList<String> lIds = uis.getTableSelection();
            if (uis.isActiveSelectionTree() || lIds == null || lIds.isEmpty()) {
                lIds = new ArrayList<String>(1);
                lIds.add(uis.getTreeSelection());
            }
            return lIds;
        }

        private void buildMenuItems(DefaultMutableTreeNode root, List lTaskNodes) {
            TaskNode tNode = null;
            Iterator iter = lTaskNodes.iterator();
            while (iter.hasNext()) {
                tNode = (TaskNode)iter.next();
                List lTaskNodeChildren = tNode.getChildren();
                if (lTaskNodeChildren != null && lTaskNodeChildren.size() > 0) {
                    DefaultMutableTreeNode group = new DefaultMutableTreeNode(tNode);
                    root.add(group);
                    this.buildMenuItems(group, lTaskNodeChildren);
                    continue;
                }
                root.add(new DefaultMutableTreeNode(tNode));
            }
        }

        public void valueChanged(ExtendedTreeSelectionEvent e) {
            TriggerContext tc = (TriggerContext)e.getContext();
            if (tc == null) {
                return;
            }
            TreePath path = e.getPath();
            Object anObj = path.getLastPathComponent();
            if (anObj == null) {
                throw new RuntimeException("Node object is not a DefaultMutableTreeNode, it is NULL!");
            }
            if (!(anObj instanceof DefaultMutableTreeNode)) {
                throw new RuntimeException("Node object is not a DefaultMutableTreeNode, it is a " + anObj.getClass().getName());
            }
            Object obj = ((DefaultMutableTreeNode)anObj).getUserObject();
            if (obj != null && obj instanceof TaskNode) {
                String url = ((TaskNode)obj).getUrlString();
                if (url == null || url.trim().length() == 0) {
                    if (this.tree.isCollapsed(path)) {
                        this.tree.expandPath(path);
                    } else {
                        this.tree.collapsePath(path);
                    }
                } else {
                    tc.setRedirectPath(url, false);
                }
            } else if (this.tree.isCollapsed(path)) {
                this.tree.expandPath(path);
            } else {
                this.tree.collapsePath(path);
            }
            this.tableFrame_.setDirty(true);
            this.tree.clearSelection(null);
        }

        public void commandPerformed(CommandEvent e) {
            WContainer row;
            WToolbarLayout actionLayout;
            WToolbar bar;
            if (e.getSource() instanceof WMenuButton && e.getCommandName().equals("Tasks") && (bar = (actionLayout = this.table_.getToolbarLayout()).getToolbar(1, 0)) != null && (row = bar.getParent()) != null) {
                row.setVisible(!row.isVisible());
            }
        }

        public WToolbar getActionToolbar() {
            return this.actionToolbar;
        }

        public WMenuButton getMenuButton() {
            return this.menuButton;
        }

        public void setActionToolbar(WToolbar toolbar) {
            this.actionToolbar = toolbar;
        }

        public void setMenuButton(WMenuButton button) {
            this.menuButton = button;
        }

        public boolean isBShowTasksLayout_() {
            return this.bShowTasksLayout_;
        }
    }
}

